*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Omethoate                               *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Newcode\Diagnostics3.SAS";
libname EPA "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\kapp data";

/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data Omethoate;
     set epa.Omethoate_avg;
run;
proc sort data=Omethoate;
     by id;
run;

/*
ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Omethoate - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Omethoate);
ods rtf close;
*/

*==> Human vs. rat;

title2 "final model 2: a model with same random effects between species";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_HR;
PROC NLMIXED data=Omethoate tech=/* newrap */ nrridg lis=3 maxiter=100000 method=firo optcheck = 0.3;
      PARMS ha=0.1 0.5 0.9	1.4	hb=0.1 0.5 0.9	1.4
			ra=0.1 0.5 0.9	1.4		rb=0.1 0.5 0.9	1.4
			gh1=0.1 0.5 0.9	1.4 gh12=0.1 0.5 0.9	1.4 gh2=0.1 0.5 0.9	1.4
			S2E=0.1 0.5 0.9	1.4 / best=50;
			gha=gh1*gh1;
			ghab=gh1*gh12/10;
			ghb=gh12*gh12/100+gh2*gh2;
            rha=ha+ua;
			rra=ra+ua;
            rhb=hb+ub;
			rrb=rb+ub;
            PRED2 = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-3 + H_I__M + rrb*Rat*1e-3 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
	  RANDOM  ua ub ~ normal([0, 0],	[gha, 
												 		 ghab,ghb]) SUBJECT=ID out=RandID_HR; 

	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12/10;
	  estimate "ghb" gh12*gh12/100+gh2*gh2;
	  id pred2;
  	  predict pred2 out=Resid_HR;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Omethoate human-rat.resids.rtf" startpage=no;
%DiagnosticsHR(chemical=Omethoate, model=2)
ods rtf close;

*==> Adult vs. Infant;


title "CEB final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_AI;
PROC NLMIXED data=Omethoate(where=(Human=1)) tech= nrridg /* newrap */ lis=3 method=firo maxiter=100000 optcheck = 0.3;
      PARMS ada=0.1 0.5 0.9	1.4 adB=0.1 0.5 0.9 1.4
			ia=.1 0.5 0.9 1.4 iB=.1 0.5 0.9 1.4
			gh1=.1 0.5 0.9 1.4 gh12=.1 0.5 0.9 1.4 gh2=.1 0.5 0.9 1.4
			S2E=.1 0.5 0.9 1.4 / best=50;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2;
			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED2 = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-3 + H_I__M*adult + rib*1e-3*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2;
	  id pred2;
      predict pred2 out=Resid_AI;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Omethoate Adult-Infant.resids.rtf" startpage=no;
%DiagnosticsAI(chemical=Omethoate, model=2);
ods rtf close;


*===> Male vs. Female;



title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_MF;
PROC NLMIXED data=Omethoate(where=(Human=1)) method=firo  /* itdetails */ tech=nrridg lis=3 maxiter=100000 optcheck=0.3;
      PARMS ma=.1 .5 .9 1.4 mb= .1 .5 .9 1.4
			fa=.1 .5 .9 1.4 fb=.1 .5 .9 1.4
			gh1=.1 .5 .9 1.4 gh12=.1 .5 .9 1.4 gh2=.1 .5 .9 1.4
			S2E=.1 .5 .9 1.4  / best=50;
			gha=gh1*gh1;
			ghab=gh1*gh12/10;
			ghb=gh12*gh12/100+gh2*gh2;
			rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED2 = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-3 + H_I__M*male + rfb*female*1e-3 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12/10;
	  estimate "ghb" gh12*gh12/100+gh2*gh2;
	  id pred2;
		predict pred2 out=Resid_MF;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Omethoate Male-Female.resids.rtf" startpage=no;
%DiagnosticsMF(chemical=Omethoate, model=2);
ods rtf close;


*===> Caucasian vs. Other Races;



title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_CO;
PROC NLMIXED data=Omethoate(where=(Human=1)) method=firo /* itdetails */ tech= nrridg lis=3 maxiter=10000  optcheck=0.3;
      PARMS ca=.1 .5 .9 1.4 	cB=.1 .5 .9 1.4 
			ora=.1 .5 .9 1.4  orB=.1 .5 .9 1.4 
			gc1=.1 .5 .9 1.4  gc12=.1 .5 .9 1.4  gc2=.1 .5 .9 1.4  
			S2E=.1 .5 .9 1.4  / best= 50;
			gca=gc1*gc1;
			gcab=gc1*gc12;
			gcb=gc12*gc12+gc2*gc2;
            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED2 = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-3 + H_I__M*caucasian + rorb*otherrace*1e-3 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);
   RANDOM  uha uhb ~ normal([0, 0],   [gca, 
														gcab, gcb]) SUBJECT=ID out=RandID_CO; 
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasain ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  estimate "gca" gc1*gc1;
	  estimate "gcab" gc1*gc12;
	  estimate "gcb" gc12*gc12+gc2*gc2;
	  id pred2;
	  predict pred2 out=Resid_CO;
run;

%let factor=0.001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\Omethoate Caucasian-Other Races.resids.rtf" startpage=no;
%DiagnosticsCO(chemical=Omethoate, model=2);
ods rtf close;

%resids